#ifndef CIRCUIT_H
#define CIRCUIT_H

#include "GlobalDefines.h"
#include "Gate_BASE.h"
#include "Gate_INPUT.h"
#include "Gate_OUTPUT.h"
#include "Gate_BUFFER.h"
#include "Gate_AND.h"
#include "Gate_NAND.h"
#include "Gate_OR.h"
#include "Gate_NOR.h"
#include "Gate_XOR.h"
#include "Gate_XNOR.h"
#include "Gate_NOT.h"
#include "Gate_DFF.h"
#include "Wire.h"
#include "Simulator.h"
#include "SimController.h"

typedef struct {
        QRectF region;
} wireSpace;

class Simulator;
class SimController;

class Circuit : public QObject
{
    Q_OBJECT
    public:
        Circuit();

        int readGates(QString file);
        int readVectors(QString file);
        int readFaults(QString file);

        QString getLastError(void);

        QMap<int, Gate_BASE*> gateIndex;
        QMap<int, QList<Gate_BASE*> > gatesPerLevel;
        int numGates;
        int numFFs;
        int numInputs;
        int numOutputs;

        bool circuitLoaded;

        QList<Wire*> wires;
        QMap<int, QList<wireSpace*> > wireVSpacing;
        QMap<int, QList<wireSpace*> > wireHSpacing;

    signals:
        void updateStatus(QString status);
        void toggleShowWireValues();

    public slots:
        void reset();
        void showSimController();

    private:
        Simulator *sim;
        SimController *simController;
        QString lastError;
};

#endif // CIRCUIT_H
